<?php $page_title="Dashboard";

include("includes/header.php");
include("includes/function.php");

error_reporting(0);

$qry_language="SELECT COUNT(*) as num FROM tbl_language";
$total_language= mysqli_fetch_array(mysqli_query($mysqli,$qry_language));
$total_language = $total_language['num'];

$qry_city="SELECT COUNT(*) as num FROM tbl_city";
$total_city= mysqli_fetch_array(mysqli_query($mysqli,$qry_city));
$total_city = $total_city['num'];

$qry_radio="SELECT COUNT(*) as num FROM tbl_radio";
$total_radio = mysqli_fetch_array(mysqli_query($mysqli,$qry_radio));
$total_radio = $total_radio['num'];

$qry_category="SELECT COUNT(*) as num FROM tbl_category";
$total_category = mysqli_fetch_array(mysqli_query($mysqli,$qry_category));
$total_category = $total_category['num']; 

$qry_demand="SELECT COUNT(*) as num FROM tbl_mp3";
$total_demand = mysqli_fetch_array(mysqli_query($mysqli,$qry_demand));
$total_demand = $total_demand['num']; 

$qry_reports="SELECT COUNT(*) as num FROM tbl_reports";
$total_reports = mysqli_fetch_array(mysqli_query($mysqli,$qry_reports));
$total_reports = $total_reports['num'];

 // Get users graph start

$countStr='';

$no_data_status=false;
$count=$monthCount=0;

for ($mon=1; $mon<=12; $mon++) {

  $monthCount++;

  if(isset($_GET['filterByYear'])){
    $year=$_GET['filterByYear'];
  }
  else{
    $year=date('Y');
  }

  $month = date('M', mktime(0,0,0,$mon, 1, $year));

  $sql_user="SELECT `id` FROM tbl_users WHERE `registered_on` <> 0 AND DATE_FORMAT(FROM_UNIXTIME(`registered_on`), '%c') = '$mon' AND DATE_FORMAT(FROM_UNIXTIME(`registered_on`), '%Y') = '$year'";

  $totalcount=mysqli_num_rows(mysqli_query($mysqli, $sql_user));

  $countStr.="['".$month."', ".$totalcount."], ";

  if($totalcount==0){
    $count++;
  }

}

if($monthCount > $count){
  $no_data_status=false;
}
else{
  $no_data_status=true;
}

$countStr=rtrim($countStr, ", ");

?>          

<?php 
$sql_smtp="SELECT * FROM tbl_smtp_settings WHERE id='1'";
$res_smtp=mysqli_query($mysqli,$sql_smtp);
$row_smtp=mysqli_fetch_assoc($res_smtp);

$smtp_warning=true;

if(!empty($row_smtp))
{

  if($row_smtp['smtp_type']=='server'){
    if($row_smtp['smtp_host']!='' AND $row_smtp['smtp_email']!=''){
      $smtp_warning=false;
    }
    else{
      $smtp_warning=true;
    }  
  }
  else if($row_smtp['smtp_type']=='gmail'){
    if($row_smtp['smtp_ghost']!='' AND $row_smtp['smtp_gemail']!=''){
      $smtp_warning=false;
    }
    else{
      $smtp_warning=true;
    }  
  }
}

if($smtp_warning)
{
  ?>
  <div class="row">
    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
      <div class="alert alert-danger alert-dismissible fade in" role="alert">
        <h4 id="oh-snap!-you-got-an-error!"><i class="fa fa-exclamation-triangle"></i> SMTP Setting is not config<a class="anchorjs-link" href="#oh-snap!-you-got-an-error!"><span class="anchorjs-icon"></span></a></h4>
        <p style="margin-bottom: 10px">Config the smtp setting otherwise <strong>forgot password</strong> OR <strong>email</strong> feature will not be work.</p> 
      </div>
    </div>
  </div>
<?php } ?>


<div class="row">
  <div class="col-lg-4 col-md-6 col-sm-6 col-xs-12"> <a href="manage_language.php" class="card card-banner card-green-light">
    <div class="card-body"> <i class="icon fa fa-language fa-4x"></i>
      <div class="content">
        <div class="title">Language</div>
        <div class="value"><span class="sign"></span><?php echo thousandsNumberFormat($total_language);?></div>
      </div>
    </div>
  </a> 
</div>
<div class="col-lg-4 col-md-6 col-sm-6 col-xs-12"> <a href="manage_city.php" class="card card-banner card-blue-light">
  <div class="card-body"> <i class="icon fa fa-sitemap fa-4x"></i>
    <div class="content">
      <div class="title">City</div>
      <div class="value"><span class="sign"></span><?php echo thousandsNumberFormat($total_city);?></div>
    </div>
  </div>
</a> 
</div>
<div class="col-lg-4 col-md-6 col-sm-6 col-xs-12"> <a href="manage_radio.php" class="card card-banner card-pink-light">
  <div class="card-body"> <i class="icon fa fa-microphone fa-4x"></i>
    <div class="content">
      <div class="title">Radio</div>
      <div class="value"><span class="sign"></span><?php echo thousandsNumberFormat($total_radio);?></div>
    </div>
  </div>
</a> 
</div>

<div class="col-lg-4 col-md-6 col-sm-6 col-xs-12"> <a href="manage_category.php" class="card card-banner card-orange-light">
  <div class="card-body"> <i class="icon fa fa-sitemap fa-4x"></i>
    <div class="content">
      <div class="title">Categories</div>
      <div class="value"><span class="sign"></span><?php echo thousandsNumberFormat($total_category);?></div>
    </div>
  </div>
</a> 
</div>
<div class="col-lg-4 col-md-6 col-sm-6 col-xs-12"> <a href="manage_mp3.php" class="card card-banner card-alicerose-light">
  <div class="card-body"> <i class="icon fa fa-music fa-4x"></i>
    <div class="content">
      <div class="title">On Demand</div>
      <div class="value"><span class="sign"></span><?php echo thousandsNumberFormat($total_demand);?></div>
    </div>
  </div>
</a> 
</div>
<div class="col-lg-4 col-md-6 col-sm-6 col-xs-12"> <a href="manage_reports.php" class="card card-banner card-yellow-light">
  <div class="card-body"> <i class="icon fa fa-bug fa-4x"></i>
    <div class="content">
      <div class="title">Reports</div>
      <div class="value"><span class="sign"></span><?php echo thousandsNumberFormat($total_reports);?></div>
    </div>
  </div>
</a> 
</div>

</div>

<div class="row">
  <div class="col-lg-12">
    <div class="container-fluid" style="background: #FFF;box-shadow: 0px 5px 10px 0px #CCC;border-radius: 2px;">
      <div class="col-lg-10">
        <h3>Users Analysis</h3>
        <p>New registrations</p>
      </div>
      <div class="col-lg-2" style="padding-top: 20px">
        <form method="get" id="graphFilter">
          <select class="form-control" name="filterByYear" style="box-shadow: none;height: auto;border-radius: 0px;font-size: 16px;">
            <?php 
              $currentYear=date('Y');
              $minYear=2018;

              for ($i=$currentYear; $i >= $minYear ; $i--) { 
                ?>
                <option value="<?=$i?>" <?=(isset($_GET['filterByYear']) && $_GET['filterByYear']==$i) ? 'selected' : ''?>><?=$i?></option>
                <?php
              }
            ?>
          </select>
        </form>
      </div>
      <div class="col-lg-12">
        <?php 
        if($no_data_status){
          ?>
          <h3 class="text-muted text-center" style="padding-bottom: 2em">No data found !</h3>
          <?php
        }
        else{
          ?>
          <div id="registerChart">
            <p style="text-align: center;"><i class="fa fa-spinner fa-spin" style="font-size:3em;color:#aaa;margin-bottom:50px" aria-hidden="true"></i></p>
          </div>
          <?php    
        }
        ?>
      </div>
    </div>
  </div>
</div>


<?php include("includes/footer.php");?>

<?php 
if(!$no_data_status){
  ?>

  <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>

  <script type="text/javascript">
    google.charts.load('current', {packages: ['corechart', 'line']});
    google.charts.setOnLoadCallback(drawChart);

    function drawChart() {

      var data = new google.visualization.DataTable();
      data.addColumn('string', 'Month');
      data.addColumn('number', 'Users');

      data.addRows([<?=$countStr?>]);

      var options = {
        curveType: 'function',
        fontSize: 15,
        hAxis: {
          title: "Months of <?=(isset($_GET['filterByYear'])) ? $_GET['filterByYear'] : date('Y')?>",
          titleTextStyle: {
            color: '#000',
            bold:'true',
            italic: false
          },
        },
        vAxis: {
          title: "Nos. of Users",
          titleTextStyle: {
            color: '#000',
            bold:'true',
            italic: false,
          },
          gridlines: { count: 5},
          format: '#',
          viewWindowMode: "explicit", viewWindow:{ min: 0 },
        },
        height: 400,
        chartArea:{
          left:100,top:20,width:'100%',height:'auto'
        },
        legend: {
          position: 'none'
        },
        lineWidth:3,
        animation: {
          startup: true,
          duration: 1200,
          easing: 'out',
        },
        pointSize: 5,
        pointShape: "circle",

      };
      var chart = new google.visualization.LineChart(document.getElementById('registerChart'));

      chart.draw(data, options);
    }

    $(document).ready(function () {
      $(window).resize(function(){
        drawChart();
      });
    });
  </script>

<?php } ?>

<script type="text/javascript">

// filter of graph
$("select[name='filterByYear']").on("change",function(e){
  $("#graphFilter").submit();
});

</script>        
     
